#include <windows.h>											// Header File For Windows
#include <stdlib.h>
#include <stdio.h>
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library

#include <math.h>

//#include <gl\glut.h>

#include "NeHeGL.h"												// Header File For NeHeGL
#include "Utils.h"
#include "CTaskList.h"
#include "CAltTabData.h"
#include "MyAlt-Tab.h"

#include "WinFunctions.h"
#include "Fonts.h"

#pragma comment( lib, "opengl32.lib" )							// Search For OpenGL32.lib While Linking
#pragma comment( lib, "glu32.lib" )								// Search For GLu32.lib While Linking
#pragma comment( lib, "glaux.lib" )								// Search For GLaux.lib While Linking
//#pragma comment( lib, "glut32.lib" )							// Search For Glut.lib While Linking
//#pragma comment( lib, "ComCtl32.lib" )								// Search For GLaux.lib While Linking
//#include <commctrl.h>

#ifndef CDS_FULLSCREEN											// CDS_FULLSCREEN Is Not Defined By Some
#define CDS_FULLSCREEN 4										// Compilers. By Defining It This Way,
#endif															// We Can Avoid Errors

#define DYN_TEXTURE_SIZE	1024

#define FONT_HEIGHT		18

GL_Window*	g_window;
Keys*		g_keys;

// User Defined Variables
float		angle;												// Used To Rotate The Triangles
int			rot1, rot2;	

// Process List
CAltTabData *procList;



BOOL Initialize (GL_Window* window, Keys* keys)					// Any GL Init Code & User Initialiazation Goes Here
{
	g_window	= window;
	g_keys		= keys;

	// Check for all working conditions

	//Check for OS version (Windows XP+)
	if(CheckOSVersion() == FALSE){
		return FALSE;
	}

	//Check for GL_EXT_texture_rectangle or GL_NV_texture_rectangle
	
	if(!IsExtensionSupported("GL_EXT_texture_rectangle") &&	!IsExtensionSupported("GL_NV_texture_rectangle")){
		return FALSE;
	}

	// OpenGL Initialization
	glClearColor (0.0f, 0.0f, 0.0f, 0.5f);						// Black Background
	glClearDepth (1.0f);										// Depth Buffer Setup
	glDepthFunc (GL_LEQUAL);									// The Type Of Depth Testing (Less Or Equal)
	glEnable (GL_DEPTH_TEST);									// Enable Depth Testing
	glShadeModel (GL_SMOOTH);									// Select Smooth Shading
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);			// Set Perspective Calculations To Most Accurate
	
	glEnable(GL_CULL_FACE);								
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

	// Initialize fonts
	InitFont(g_window->hDC, "Tahoma", FONT_HEIGHT, FW_HEAVY, false);

	//InitCommonControls();

		

	// Initialize the processes information
	
	procList = new CAltTabData();

	

	RECT r;	
	GetWindowRect(g_window->hWnd, &r);
	
	//AnimateWindow(g_window->hWnd, 1, AW_BLEND | AW_HIDE);
	//ShowWindow(g_window->hWnd, SW_HIDE);

	//char str[512] = "";
	//sprintf(str, "%d, %d, %d, %d", r.left, r.top, r.right - r.left, r.bottom - r.top);
    //MessageBox(NULL, str, "info", MB_OK);
	
	CreateBackgroundTexture(&procList->m_backTexture, r.left, r.top, r.right - r.left, r.bottom - r.top);
		
	//sprintf(str, "%d, %x", procList->m_backTexture, &procList->m_backTexture);
 //   MessageBox(NULL, str, "info", MB_OK);

	ShowWindow(g_window->hWnd, SW_SHOW);
	//AnimateWindow(g_window->hWnd, 1, AW_BLEND);
	SetForegroundWindow(g_window->hWnd);

	// Start Of User Initialization
	angle		= 0.0f;											// Set Starting Angle To Zero

	


	return TRUE;												// Return TRUE (Initialization Successful)
}

void Deinitialize (void)										// Any User DeInitialization Goes Here
{
	glDeleteTextures(1, &procList->m_backTexture);
	delete procList;

	// Destroy fonts
	DestroyFont();
}

void Update (DWORD milliseconds)								// Perform Motion Updates Here
{
	if (g_keys->keyDown [VK_ESCAPE] == TRUE)					// Is ESC Being Pressed?
	{
		TerminateApplication (g_window);						// Terminate The Program
	}

	if (g_keys->keyDown [VK_F1] == TRUE)						// Is F1 Being Pressed?
	{
		ToggleFullscreen (g_window);							// Toggle Fullscreen Mode
	}

	if(g_keys->keyDown[VK_LEFT]){		
		
		procList->m_selectedTaskIdx = (procList->m_selectedTaskIdx+1) % procList->m_nTasks;
		
		procList->m_displayAngle = procList->m_selectedTaskIdx * procList->m_unitAngle;
		procList->m_displayAngle = (procList->m_displayAngle > 360.0f) ? 0 : procList->m_displayAngle;

		CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
		
		//char str[1024] = "";
		//sprintf(str, "%d - %d",cti.taskWidth, cti.taskHeight);
		SetWindowText(g_window->hWnd, cti.taskText);	
		
		g_keys->keyDown[VK_LEFT] = FALSE;

		procList->calculateDrawingOrder();
	}

	if(g_keys->keyDown[VK_RIGHT]){
		
		if(procList->m_selectedTaskIdx == 0){
			procList->m_selectedTaskIdx = procList->m_nTasks - 1;
		} else {
			procList->m_selectedTaskIdx = (procList->m_selectedTaskIdx-1);
		}

		procList->m_displayAngle = procList->m_selectedTaskIdx * procList->m_unitAngle;
		procList->m_displayAngle = (procList->m_displayAngle > 360.0f) ? 0 : procList->m_displayAngle;

		CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
		
		//char str[1024] = "";
		//sprintf(str, "%d - %s",procList->m_selectedTaskIdx, cti.taskText);
		SetWindowText(g_window->hWnd, cti.taskText);	

		g_keys->keyDown[VK_RIGHT] = FALSE;

		procList->calculateDrawingOrder();
	}



	static int factor = 5;
	if(angle > 90.0 && angle <180.0)
		factor = 7;
	else if(angle > 180.0 && angle <360.0)
		factor = 10;
	else 
		factor = 100;
	angle += (float)(((milliseconds) /*% factor*/)) / 5.0f;						// Update angle Based On The Clock
	//angle = angle>360.0f?0:angle;
	
	
	
}

void DrawTasks(){
	
	glDisable(GL_CULL_FACE);

	glPushMatrix();
	//glTranslatef (0.0f, 0.0f, -10.0f);
	//glRotatef (-90.0, 1.0f, 0.0f, 0.0f);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	for (int t = 0; t< procList->m_nTasks; t++)								// 2 Passes
	{	
		glRotatef(360.0 - procList->m_drawOrder[t]*procList->m_unitAngle,0.0f,1.0f,0.0f);						// Rotate 90 Degrees On The Y-Axis		
		glTranslatef (0.0f, 0.0f, procList->m_displacement);

		float c = (procList->m_drawOrder[t]+1)*procList->m_unitAngle / 360.0;
		
		if(procList->m_drawOrder[t] == procList->m_selectedTaskIdx){
			glColor4f (0,0, c, 0.90);	
		} else {
			glColor4f (0,0, c, 0.5);	
			//glDepthMask(GL_FALSE);
		}
		CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_drawOrder[t]);

		//glutSolidSphere(0.5, 30,30);		
		glEnable(GL_TEXTURE_RECTANGLE);
		glBindTexture(GL_TEXTURE_RECTANGLE, procList->m_taskTextures[procList->m_drawOrder[t]]);

		int ww = tInfo.taskWidth;
		int hh = tInfo.taskHeight;

		float ratio = (float)ww / (float)hh;

		float ws = SHAPE_WIDTH;
		float hs = SHAPE_HEIGHT;

		/*if(tInfo.taskIconic){
			ws = hs = 0.5;
		}*/

		if(ratio >= 1){
			hs /= ratio;
		} else {
			ws *= ratio;
		}

		glBegin (GL_QUADS);								// Begin Drawing Triangles
			glTexCoord2f(0.0, hh);   glVertex3f( -ws, hs, 0.0f);
			glTexCoord2f(0.0, 0.0);  glVertex3f(-ws,-hs, 0.0f);
			glTexCoord2f( ww, 0.0);  glVertex3f( ws,-hs, 0.0f);
			glTexCoord2f( ww, hh);   glVertex3f( ws,hs, 0.0f);
		glEnd ();											// Done Drawing Triangles
		

		glDisable(GL_TEXTURE_RECTANGLE);

		//glDepthMask(GL_TRUE);
		glTranslatef (0.0f, 0.0f, -procList->m_displacement);

		glRotatef(-(360.0 - procList->m_drawOrder[t]*procList->m_unitAngle),0.0f,1.0f,0.0f);	
	}
	
	glDisable(GL_BLEND);
	glPopMatrix();

	glEnable(GL_CULL_FACE);
	


	glFlush ();													// Flush The GL Rendering Pipeline

	return;
}
//#include "gl/glut.h"

void DrawTaskText(){

	// Fonts
/*	
	RECT r; GetClientRect(g_window->hWnd, &r);

HFONT font = CreateFont(20, 10, 0, 0, FW_BOLD, 0, 0, 0,
  ANSI_CHARSET, OUT_DEVICE_PRECIS, 
  CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH, "Tahoma");

SelectObject(g_window->hDC, font);



SetBkMode(g_window->hDC, TRANSPARENT);


CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
int len = strlen(tInfo.taskText);
WCHAR szText[MAX_TEXT_LENGHT] = L"";
if (!InternalGetWindowText(tInfo.task, szText, MAX_TEXT_LENGHT)){
			InternalGetWindowText(tInfo.taskPv, szText, MAX_TEXT_LENGHT);
}
DrawShadowText(g_window->hDC, szText, len, &r,DT_BOTTOM | DT_CENTER | DT_SINGLELINE | DT_NOPREFIX | DT_END_ELLIPSIS, RGB(255,255,255), RGB(0,0,0), 2, 2);
//DrawText(g_window->hDC, tInfo.taskText, (len <= 50)?len:50, &r, DT_BOTTOM | DT_CENTER | DT_SINGLELINE );


DeleteObject(font); 

*/
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();		
		//glLoadIdentity ();

			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

			glBegin (GL_QUAD_STRIP);								// Begin Drawing Triangles

				glColor4ub(214, 219, 191,0);
				glVertex3f(  0,  0, ZNEAR_2D_FIX);
				glVertex3f(  0, 25, ZNEAR_2D_FIX);				

				glColor4ub(214, 219, 191,245);
				glVertex3f( 15,  0, ZNEAR_2D_FIX);
				glVertex3f( 15, 25, ZNEAR_2D_FIX);				

				glVertex3f(WindowWidth - 15,  0, ZNEAR_2D_FIX);
				glVertex3f(WindowWidth - 15, 25, ZNEAR_2D_FIX);				

				glColor4ub(214, 219, 191,0);
				glVertex3f(WindowWidth,  0, ZNEAR_2D_FIX);
				glVertex3f(WindowWidth, 25, ZNEAR_2D_FIX);				
				
			glEnd ();											// Done Drawing Triangles
			
			glDisable(GL_BLEND);
			
			CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_selectedTaskIdx);

			char txt[65] = "";

			strncpy(txt, tInfo.taskText, 60*sizeof(char));
			if(strlen(tInfo.taskText) > 60){
				txt[60] = txt[61] = txt[62] = '.';
				txt[63] = '\0';
			}

			/*
			Good, but requires to much CPU time
			
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			


			glColor4f(0.25, 0.25, 0.25,0.25);

			glRasterPos3f(1.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(2.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(4.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(2.0,FONT_HEIGHT-1.0, ZNEAR_2D_FIX);			
			glDraw2DText(txt);

			glRasterPos3f(1.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(4.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(4.0,FONT_HEIGHT+2, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(2.0,FONT_HEIGHT-1.0, ZNEAR_2D_FIX);			
			glDraw2DText(txt);

			
			glColor4f(0.1, 0.1, 0.1,0.65);			
			glRasterPos3f(3.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
			glDraw2DText(txt);
			glRasterPos3f(2.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
			glDraw2DText(txt);

			glDisable(GL_BLEND);*/

			
			glColor4ub(107, 109, 95,250);
			glRasterPos3f(15.0,FONT_HEIGHT - 0.5, ZNEAR_2D_FIX);
			glDraw2DText(txt);
			
						
			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glFlush ();													// Flush The GL Rendering Pipeline

	return;
}


void Draw (void)
{
	if(procList->m_nTasks == 0){
		g_keys->keyDown[VK_ESCAPE] == TRUE;
		return;
	}

	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear Screen And Depth Buffer
	glClearColor(0.0f, 0.0f, 0.3f, 0.0f);						// Black Background	
	glLoadIdentity ();											// Reset The Modelview Matrix
		
	static float displacement = SHAPE_WIDTH*2 + 1.5*procList->m_displacement;
	glTranslatef (0.0f, 0.0f, -(displacement));							// Translate 6 Units Into The Screen
	glRotatef (procList->m_displayAngle, 0.0f, 1.0f, 0.0f);						// Rotate On The Y-Axis By angle

	//glRotatef (180.0, 0.0f, 1.0f, 0.0f);

	//Render to texture stuff
	glEnable(GL_TEXTURE_RECTANGLE);
	glBindTexture(GL_TEXTURE_RECTANGLE, procList->m_backTexture);
		
	//glReadPixels(	
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();
			
		float zz = -(zFar-zNear);
						
			//float ww = (float)WindowWidth/1024.0;
			//float hh = (float)WindowHeight/1024.0;
			//glEnable(GL_BLEND);
			glColor4f(1.0, 1.0, 1.0,0.5);
			glBegin(GL_QUADS);			

				glTexCoord2f(0.0, WindowHeight);  glVertex3f(0, 0, zz);
				glTexCoord2f(0.0, 0.0);  glVertex3f(0, WindowHeight, zz);
				glTexCoord2f(WindowWidth, 0.0);  glVertex3f(WindowWidth, WindowHeight, zz);
				glTexCoord2f(WindowWidth, WindowHeight);  glVertex3f(WindowWidth, 0, zz);
			glEnd();
			//glDisable(GL_BLEND);
			
			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glDisable(GL_TEXTURE_RECTANGLE);

	DrawTasks();

	//static float a = -10.0;
	

	DrawTaskText();

	
	
	glFlush ();													// Flush The GL Rendering Pipeline
}
